/*
 * Decompiled with CFR 0.152.
 */
package levosilimo.everlastingskins.skinchanger;

import com.google.common.hash.Hashing;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import levosilimo.everlastingskins.Config;
import levosilimo.everlastingskins.EverlastingSkins;
import levosilimo.everlastingskins.enums.LanguageEnum;
import levosilimo.everlastingskins.enums.SkinActionType;
import levosilimo.everlastingskins.enums.SkinVariant;
import levosilimo.everlastingskins.skinchanger.EmulateReconnectPacket;
import levosilimo.everlastingskins.skinchanger.MineskinSkinProvider;
import levosilimo.everlastingskins.skinchanger.MojangSkinProvider;
import levosilimo.everlastingskins.skinchanger.RandomMojangSkin;
import levosilimo.everlastingskins.skinchanger.SkinRestorer;
import levosilimo.everlastingskins.skinchanger.SkinStorage;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public class SkinCommand {
    private static String processing = "";
    private static String changeOP = "";
    private static String recon_needed = "";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skin").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mojang").then(Commands.m_82129_((String)"nickname", (ArgumentType)StringArgumentType.word()).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.nickname, false, SkinVariant.all, false, StringArgumentType.getString((CommandContext)context, (String)"nickname"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).then(Commands.m_82129_((String)"nickname", (ArgumentType)StringArgumentType.word()).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.nickname, true, SkinVariant.all, false, StringArgumentType.getString((CommandContext)context, (String)"nickname"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"web").then(Commands.m_82127_((String)"classic").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.url, false, SkinVariant.classic, false, StringArgumentType.getString((CommandContext)context, (String)"url")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.url, true, SkinVariant.classic, true, StringArgumentType.getString((CommandContext)context, (String)"url"))))))).then(Commands.m_82127_((String)"slim").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.url, false, SkinVariant.slim, false, StringArgumentType.getString((CommandContext)context, (String)"url")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.url, true, SkinVariant.slim, true, StringArgumentType.getString((CommandContext)context, (String)"url")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"random").executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.random, false, SkinVariant.all, false, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.random, true, SkinVariant.all, false, null)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"classic").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cape").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.random, true, SkinVariant.classic, true, null)))).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.random, false, SkinVariant.classic, true, null)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"new").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.NEW, true, SkinVariant.classic, false, null)))).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.NEW, false, SkinVariant.classic, false, null)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.random, true, SkinVariant.classic, false, null)))).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.random, false, SkinVariant.classic, false, null)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"slim").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cape").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.random, true, SkinVariant.slim, true, null)))).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.random, false, SkinVariant.slim, true, null)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"new").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.NEW, true, SkinVariant.slim, false, null)))).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.NEW, false, SkinVariant.slim, false, null)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.random, true, SkinVariant.slim, false, null)))).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.random, false, SkinVariant.slim, false, null)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"source").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> SkinRestorer.getSkinIO().getSource(EntityArgument.m_91474_((CommandContext)context, (String)"target").m_20148_())))).executes(context -> SkinRestorer.getSkinIO().getSource(((CommandSourceStack)context.getSource()).m_81375_().m_20148_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> SkinCommand.skinAction(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), SkinActionType.clear, true, SkinVariant.all, false, null)))).executes(context -> SkinCommand.skinAction(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SkinActionType.clear, false, SkinVariant.all, false, null))));
    }

    private static int skinAction(Collection<ServerPlayer> targets, SkinActionType type, boolean setByOperator, SkinVariant variant, boolean withCape, @Nullable String customSource) {
        CompletionStage future = CompletableFuture.supplyAsync(() -> {
            LanguageEnum a = (LanguageEnum)((Object)((Object)Config.LANGUAGE.get()));
            switch (a) {
                case Russian: {
                    processing = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f \u0420\u045b\u0420\u00b1\u0421\u0402\u0420\u00b0\u0420\u00b1\u0420\u00b0\u0421\u201a\u0421\u2039\u0420\u0406\u0420\u00b0\u0420\u00b5\u0420\u0458...";
                    changeOP = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f \u0420\u045b\u0420\u0457\u0420\u00b5\u0421\u0402\u0420\u00b0\u0421\u201a\u0420\u0455\u0421\u0402 \u0420\u0451\u0420\u00b7\u0420\u0458\u0420\u00b5\u0420\u0405\u0420\u0451\u0420\u00bb \u0420\u0406\u0420\u00b0\u0421\u20ac \u0421\u0403\u0420\u0454\u0420\u0451\u0420\u0405.";
                    recon_needed = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f \u0420\u040e\u0420\u0454\u0420\u0451\u0420\u0405 \u0420\u0457\u0421\u0402\u0420\u0451\u0420\u0458\u0420\u00b5\u0420\u0405\u0421\u2018\u0420\u0405.";
                    break;
                }
                case Ukrainian: {
                    processing = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f \u0420\u045b\u0420\u0457\u0421\u0402\u0420\u00b0\u0421\u2020\u0421\u040a\u0420\u0455\u0420\u0406\u0421\u0453\u0421\u201d\u0420\u0458\u0420\u0455...";
                    changeOP = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f \u0420\u045b\u0420\u0457\u0420\u00b5\u0421\u0402\u0420\u00b0\u0421\u201a\u0420\u0455\u0421\u0402 \u0420\u00b7\u0420\u0458\u0421\u2013\u0420\u0405\u0420\u0451\u0420\u0406 \u0420\u0406\u0420\u00b0\u0421\u20ac \u0421\u0403\u0420\u0454\u0421\u2013\u0420\u0405.";
                    recon_needed = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f \u0420\u040e\u0420\u0454\u0421\u2013\u0420\u0405 \u0420\u00b7\u0420\u00b0\u0421\u0403\u0421\u201a\u0420\u0455\u0421\u0403\u0420\u0455\u0420\u0406\u0420\u00b0\u0420\u0405\u0420\u0455.";
                    break;
                }
                default: {
                    processing = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f Processing...";
                    changeOP = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f Operator changed your skin.";
                    recon_needed = "\u0412\u00a76[EverlastingSkins]\u0412\u00a7f Skin has been applied.";
                }
            }
            if (!setByOperator) {
                ((ServerPlayer)targets.stream().findFirst().get()).m_213846_((Component)Component.m_237113_((String)processing));
            }
            Property skin = null;
            String source = "";
            ArrayList<EmulateReconnectPacket> packets = new ArrayList<EmulateReconnectPacket>();
            if (customSource != null) {
                source = customSource;
            }
            switch (type) {
                case clear: {
                    skin = MojangSkinProvider.getSkin(((ServerPlayer)targets.stream().findFirst().get()).m_36316_().getName());
                    break;
                }
                case url: {
                    skin = MineskinSkinProvider.getSkin(customSource, variant);
                    break;
                }
                case nickname: {
                    skin = MojangSkinProvider.getSkin(customSource);
                    break;
                }
                case random: {
                    source = RandomMojangSkin.randomNickname(withCape, variant, false);
                    skin = MojangSkinProvider.getSkin(source);
                    break;
                }
                case NEW: {
                    source = RandomMojangSkin.randomNickname(false, variant, true);
                    skin = MojangSkinProvider.getSkin(source);
                }
            }
            for (ServerPlayer player : targets) {
                if (!source.isEmpty()) {
                    SkinStorage.sourceMap.put(player.m_20148_(), source);
                } else {
                    SkinStorage.sourceMap.put(player.m_20148_(), player.m_36316_().getName());
                }
                SkinRestorer.getSkinStorage().setSkin(player.m_20148_(), skin);
                if (setByOperator) {
                    player.m_213846_((Component)Component.m_237113_((String)changeOP));
                    continue;
                }
                player.m_213846_((Component)Component.m_237113_((String)recon_needed));
            }
            for (ServerPlayer player : targets) {
                ServerLevel world = player.m_9236_();
                packets.add(SkinCommand.generatePacket(player, world));
            }
            return packets;
        }, EverlastingSkins.skinCommandExecutor).orTimeout(10L, TimeUnit.SECONDS).whenComplete((result, exception) -> {
            if (SkinRestorer.server != null) {
                SkinRestorer.server.execute(() -> result.forEach(EmulateReconnectPacket::emulateReconnect));
            }
        });
        return targets.size();
    }

    private static EmulateReconnectPacket generatePacket(ServerPlayer player, ServerLevel world) {
        ResourceKey dimensionType = player.m_9236_().m_6018_().m_220362_();
        ResourceKey registryKey = player.m_9236_().m_46472_();
        long seedEncrypted = Hashing.sha256().hashString((CharSequence)String.valueOf(player.m_9236_().m_7328_()), StandardCharsets.UTF_8).asLong();
        GameType gameType = player.f_8941_.m_9290_();
        GameType previousGameType = player.f_8941_.m_9293_();
        boolean isDebug = player.m_9236_().m_46659_();
        boolean isFlat = player.m_9236_().m_8584_();
        SkinRestorer.getSkinStorage().removeSkin(player.m_20148_());
        player.m_36316_().getProperties().removeAll((Object)"textures");
        player.m_36316_().getProperties().put((Object)"textures", (Object)SkinRestorer.getSkinStorage().getSkin(player.m_20148_()));
        int HeldSlot = player.m_150109_().f_35977_;
        Abilities abilities = player.m_150110_();
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        float yaw = player.m_146909_();
        float pitch = player.m_146908_();
        float headYaw = player.m_6080_();
        int yawPacket = Mth.m_14143_((float)(player.m_6080_() * 256.0f / 360.0f));
        HashSet<ClientboundPlayerPositionPacket.RelativeArgument> flags = new HashSet<ClientboundPlayerPositionPacket.RelativeArgument>();
        return new EmulateReconnectPacket(player, world, x, y, z, yaw, pitch, headYaw, (byte)yawPacket, flags, HeldSlot, abilities, (ResourceKey<DimensionType>)dimensionType, (ResourceKey<Level>)registryKey, seedEncrypted, gameType, previousGameType, isDebug, isFlat);
    }
}

